IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CP_SCA_ValidarProducVta_Kit') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE dbo.CP_SCA_ValidarProducVta_Kit
END
GO

CREATE PROCEDURE [dbo].[CP_SCA_ValidarProducVta_Kit] @pId_Cliente		INT, 
												@pId_Acceso			SMALLINT, 
												@pFecha				DATETIME, 
												@pId_Cliente_Ref	INT, 
												@pHorario			TINYINT, 
												@Id_Producto		VARCHAR(14) OUTPUT
AS
BEGIN

--======= Variables Locales =======--
DECLARE @Flag_PermiteProdPorPed	INT
DECLARE @Est_Pedido_Habili		VARCHAR(8000)
DECLARE @SqlStr					NVARCHAR(MAX)
DECLARE @SqlSelect				NVARCHAR(MAX)
DECLARE @SqlFrom				NVARCHAR(MAX)
DECLARE @SqlWhere				NVARCHAR(MAX)
DECLARE @SqlWhereEsp			NVARCHAR(MAX)
DECLARE @Parametros				NVARCHAR(100)
DECLARE @DiaActual				TINYINT

DECLARE @ExisteRemito						INT
DECLARE @Cantidad_Saldo						INT
DECLARE @Id_Tipo_Cbte						CHAR(4)
DECLARE @json								VARCHAR(8000)
DECLARE @Id_Trans_Rem						INT
DECLARE @Id_Trans_Fac						INT
DECLARE @Result_Stored_Invocado				INT
DECLARE @Result_Tabla_Stored_Invocado		TABLE (ErrorNumber	INT,
											ErrorSeverity	INT,
											ErrorState		INT,
											ErrorProcedure  VARCHAR(1000),
											ErrorLine		INT,
											ErrorMessage	VARCHAR(4000))
DECLARE @rtaErrorStored						INT
DECLARE @rtaMsjStored						VARCHAR(4000)
DECLARE @JSON_Parametros_Stored_Invocado	VARCHAR(8000)
DECLARE @rta_JSON_Stored_Invocado			VARCHAR(8000)
--======= Fin Variables Locales =======--

SET @Parametros = N'@Id_ProductoOUT VARCHAR(14) OUTPUT'; 

SET @Id_Producto	= ''

SET @Flag_PermiteProdPorPed =  (dbo.CF_xParam('SCA_Perm_ProdXPed'))
SET @Est_Pedido_Habili		= RTRIM(LTRIM((dbo.CF_xParam('SCA_Est_Ped_Habil'))))

IF (ISNULL(@pId_Cliente_Ref,0) <> 0)
BEGIN
   SET @pId_Cliente = @pId_Cliente_Ref
END

--=========================================== Chequear si tiene un producto Pack Comprado --=================================================

SET @SqlStr = 'SELECT @Id_ProductoOUT = ISNULL(MAX(CI.Id_Producto),'''')'

IF(ISNULL(@pHorario,0) = 0)
BEGIN
   SET @SqlStr = RTRIM(LTRIM(@SqlStr)) + CHAR(13) + 
				' FROM Cbtes_Items CI, Cbtes CB, Cbtes_Tipos CT, CD_Accesos_Prod CA, Productos PR'
END
ELSE
BEGIN
   SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) + 
					' FROM Cbtes_Items CI, Cbtes CB, Cbtes_Tipos CT, CD_Accesos_Horarios CA, Productos PR'
END


SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) + 
				' WHERE' + CHAR(13) + 
				' CI.Id_Trans = CB.Id_Trans ' + CHAR(13) +
				' AND CT.Id_Tipo_Cbte = CB.Id_Tipo_Cbte' + CHAR(13) +
				' AND CA.Id_Acceso = '+ CAST(@pId_Acceso AS VARCHAR(5)) + CHAR(13) +
				' AND CA.Id_Producto = CI.Id_Producto' + CHAR(13) +
				' AND CI.Id_Cliente = '+ CAST(@pId_Cliente AS VARCHAR(10)) + CHAR(13) +
				' AND PR.Id_Producto = CA.Id_Producto '

IF @Flag_PermiteProdPorPed = 0 ----incluismo pedidos o no
   SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) + 
					' AND ((CT.Compromete_Factura = 1 ' + CHAR(13) + 
					' AND CB.Id_Estado_Cbte IN (4, 2))' + CHAR(13) + 
					' OR (CB.Id_Estado_Cbte IN (1) AND CI.Imp_Final = 0))' + CHAR(13) +
					' AND dbo.CF_NC_A_FC(CB.Id_Trans) = 0'
ELSE
   SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) + 
					' AND ((CT.Compromete_Factura = 1 AND CB.Id_Estado_Cbte IN (4, 2))' + CHAR(13) +
					' OR (CT.Compromete_Factura = 1 AND CB.Id_Estado_Cbte IN (1) AND CI.Imp_Final = 0)' + CHAR(13) +
					' OR (CT.Compromete_Pedido = 1 AND CB.Id_Estado_Cbte IN (' + @Est_Pedido_Habili + ')))'+ CHAR(13) +
					' AND dbo.CF_NC_A_FC(CB.Id_Trans) = 0'

IF(ISNULL(@pHorario,0) = 0)
BEGIN
	IF(ISNULL(@pId_Cliente_Ref,0) = 0)
		SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) + 
						' AND ISNULL(CA.Valida_En_Titular,0) = 0'
	ELSE
		SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) + 
						' AND ISNULL(CA.Valida_En_Titular,0) = 1'
END

SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) + 
						' AND ISNULL(CA.Flag_Consumible,0) = 1'

--SET @SqlStr = @SqlSelect + @SqlFrom + @SqlWhere
PRINT @SqlStr 
EXECUTE sp_executesql @SqlStr, @Parametros, @Id_ProductoOUT = @Id_Producto OUTPUT;

--================================================= Verificar que exista un remito para ese día --=================================================

IF (@Id_Producto <> '')
BEGIN
	SET @ExisteRemito = ISNULL((SELECT COUNT(*) FROM Cbtes C, Cbtes_Tipos T, Cbtes_Items I 
									WHERE C.Id_Tipo_Cbte = T.Id_Tipo_Cbte 
									AND C.Id_Trans=I.Id_Trans
									AND T.Compromete_Remitos IN (1, -1)
									AND C.Id_Estado_Cbte = 2
									AND I.Id_Producto = @Id_Producto
									AND I.Id_Cliente = @pId_Cliente
									AND CONVERT(DATE, C.Fecha) = CONVERT(date, @pFecha)),0)
	IF (@ExisteRemito > 0)
	BEGIN
		PRINT 'Existe remito para el día actual'
		RETURN
	END
	ELSE
	BEGIN
		PRINT 'Se genera remito para el día actual'
		
		SELECT TOP 1 @Cantidad_Saldo = ISNULL(MAX(CI.Cantidad_Saldo),0), 
				@Id_Trans_Fac = CB.Id_Trans
				FROM Cbtes_Items CI, Cbtes CB, Cbtes_Tipos CT
				WHERE CI.Id_Trans = CB.Id_Trans 
				AND CT.Id_Tipo_Cbte = CB.Id_Tipo_Cbte
				AND CI.Id_Cliente = @pId_Cliente
				AND CI.Id_Producto = @Id_Producto
				AND ((CT.Compromete_Factura = 1 AND CB.Id_Estado_Cbte IN (4, 2))
				OR (CB.Id_Estado_Cbte IN (1) AND CI.Imp_Final = 0))
				AND CI.Cantidad_Saldo > 0
				GROUP BY CI.Cantidad_Saldo, CB.Id_Trans
				ORDER BY CB.Id_Trans ASC

		IF (@Cantidad_Saldo > 0)
		BEGIN
			SET @Id_Tipo_Cbte	= (SELECT Id_Tipo_Cbte FROM CD_Accesos_Prod WHERE Id_Acceso = @pId_Acceso AND Id_Producto = @Id_Producto)

			SET @json =	'{'
				SET @json =	@json + '"FlagUsarTrans":"1"'
				SET @json =	@json +	',"ModoDebug":"0"'
				SET @json =	@json +	',"Id_Usuario":"-1"'
				SET @json =	@json +	',"Id_Tipo_Cbte":"' + CONVERT(VARCHAR(4), @Id_Tipo_Cbte ) +'"'
				SET @json =	@json +	',"Fecha":"' + CONVERT(VARCHAR(10), @pFecha, 112) +'"'
				SET @json =	@json +	',"Id_Cliente":"' + CONVERT(VARCHAR(10), @pId_Cliente) +'"'
				SET @json =	@json +	',"Fecha_Estimada":"' + CONVERT(VARCHAR(10), @pFecha, 112) +'"'
				SET @json =	@json +	',"Id_Cond_Pago":"10"'
				SET @json =	@json +	',"Lote":"DESCUENTO_PROD_SCA"'
				SET @json =	@json +	'}'

				SET @Id_Trans_Rem = 0
				DELETE @Result_Tabla_Stored_Invocado
	
				INSERT INTO @Result_Tabla_Stored_Invocado  
				EXEC @Result_Stored_Invocado = dbo.CPJ_Cbtes_Rem_Generar @json

				IF ISNULL(@Result_Stored_Invocado, 0) <> 0 
				BEGIN
					RAISERROR ('Error when calling CPJ_Cbtes_Rem_Generar', 16,  1 ) 
				END
				ELSE
				BEGIN
					SELECT TOP 1 @rta_JSON_Stored_Invocado = ErrorMessage FROM @Result_Tabla_Stored_Invocado
					SET @Id_Trans_Rem = ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@rta_JSON_Stored_Invocado,'Id_Trans')), 0)
				END

			PRINT '@Id_Trans_Rem: '+ CONVERT (VARCHAR (15), @Id_Trans_Rem)

			IF(@Id_Trans_Rem > 0)
				BEGIN
					SET @json =	'{'
					SET @json =	@json + '"FlagUsarTrans":"1"'
					SET @json =	@json +	',"ModoDebug":"0"'
					SET @json =	@json +	',"Id_Trans":"' + CONVERT(VARCHAR(10), @Id_Trans_Rem) +'"'
					SET @json =	@json +	',"Id_Cliente":"' + CONVERT(VARCHAR(10), @pId_Cliente) +'"'
					SET @json =	@json +	',"Id_Producto":"' + CONVERT(VARCHAR(10), @Id_Producto) +'"'
					SET @json =	@json +	',"Cantidad":"1"'
					SET @json =	@json +	',"Fecha_QA":"' + CONVERT(VARCHAR(10), @pFecha, 112) +'"'
					SET @json =	@json +	',"Fecha_Venc":"' + CONVERT(VARCHAR(10), @pFecha, 112) +'"'
					SET @json =	@json +	',"Refacturar":"1"'
					SET @json =	@json +	'}'

					EXEC dbo.CPJ_Cbtes_Rem_Generar_Item @json

				END

			IF(@Id_Trans_Rem > 0)
				BEGIN
					SET @json =	'{'
					SET @json =	@json + '"FlagUsarTrans":"1"'
					SET @json =	@json +	',"ModoDebug":"0"'
					SET @json =	@json +	',"Id_Trans":"' + CONVERT(VARCHAR(10), @Id_Trans_Rem) +'"'
					SET @json =	@json +	'}'

					EXEC dbo.CPJ_Cbtes_Rem_Fin @json

				END

			UPDATE Cbtes_Items SET Cantidad_Saldo -= 1 WHERE Id_Trans= @Id_Trans_Fac AND Id_Producto = @Id_Producto
			UPDATE Cbtes SET Id_Trans_Origen = @Id_Trans_Fac, Id_Estado_Cbte = 2 WHERE Id_Trans = @Id_Trans_Rem
			RETURN
		END
		ELSE
		BEGIN
			SET @Id_Producto = ''
			RETURN
		END
	END
END

--============================================================================================================================================================

RETURN
END


/*

EXEC dbo.CP_SCA_ValidarProducVta_Kit 3840537, 
									 6, 
									 '20221128', 
									 0, 
									 0, 
									 ''

*/